package ru.yandex.mail.so.jrbld.config;

import java.util.LinkedHashSet;
import java.util.Set;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractIpCheckerConfigBuilder
    <T extends AbstractIpCheckerConfigBuilder<T>>
    implements IpCheckerConfig
{
    private Set<String> sources;

    protected AbstractIpCheckerConfigBuilder(final IpCheckerConfig config) {
        sources(config.sources());
    }

    protected AbstractIpCheckerConfigBuilder(
        final IniConfig config,
        final IpCheckerConfig defaults)
        throws ConfigException
    {
        sources = SOURCES.extract(config, defaults.sources());
    }

    protected abstract T self();

    @Override
    public Set<String> sources() {
        return sources;
    }

    public T sources(final Set<String> sources) {
        this.sources = new LinkedHashSet<>(sources);
        return self();
    }
}

