package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.util.ip.AbstractIpListConfigBuilder;

public abstract class AbstractIpListSourceConfigBuilder
    <T extends AbstractIpListSourceConfigBuilder<T>>
    extends AbstractIpListConfigBuilder<T>
    implements IpListSourceConfig
{
    private int value;

    protected AbstractIpListSourceConfigBuilder(final IpListSourceConfig config) {
        super(config);
        value(config.value());
    }

    protected AbstractIpListSourceConfigBuilder(
        final IniConfig config,
        final IpListSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        value = JrbldConfig.VALUE.extract(config, defaults.value());
    }

    @Override
    public int value() {
        return value;
    }

    public T value(final int value) {
        this.value = value;
        return self();
    }
}

