package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.util.ip.AbstractIpRangeListConfigBuilder;

public abstract class AbstractIpRangeListSourceConfigBuilder
    <T extends AbstractIpRangeListSourceConfigBuilder<T>>
    extends AbstractIpRangeListConfigBuilder<T>
    implements IpRangeListSourceConfig
{
    private int value;

    protected AbstractIpRangeListSourceConfigBuilder(
        final IpRangeListSourceConfig config)
    {
        super(config);
        value(config.value());
    }

    protected AbstractIpRangeListSourceConfigBuilder(
        final IniConfig config,
        final IpRangeListSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        value = JrbldConfig.VALUE.extract(config, defaults.value());
    }

    @Override
    public int value() {
        return value;
    }

    public T value(final int value) {
        this.value = value;
        return self();
    }
}

