package ru.yandex.mail.so.jrbld.config;

import java.util.HashMap;
import java.util.Map;

import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;
import ru.yandex.search.proxy.universal.AbstractUniversalSearchProxyConfigBuilder;

public abstract class AbstractJrbldConfigBuilder
    <T extends AbstractJrbldConfigBuilder<T>>
    extends AbstractUniversalSearchProxyConfigBuilder<T>
    implements JrbldConfig
{
    private static final String TYPE = "type";

    private boolean enableCheckersStaters;
    private Map<String, JniWrapperConfigBuilder> jniInfoSourceConfigs;
    private Map<String, LuceneSourceConfigBuilder> luceneSourceConfigs;
    private Map<String, IpListSourceConfigBuilder> ipListSourceConfigs;
    private Map<String, IpRangeListSourceConfigBuilder>
        ipRangeListSourceConfigs;
    private Map<String, CidrListSourceConfigBuilder> cidrListSourceConfigs;
    private Map<String, IpCheckerConfigBuilder> ipCheckerConfigs;

    protected AbstractJrbldConfigBuilder(final JrbldConfig config) {
        super(config);
        enableCheckersStaters(config.enableCheckersStaters());
        jniInfoSourceConfigs(config.jniInfoSourceConfigs());
        luceneSourceConfigs(config.luceneSourceConfigs());
        ipListSourceConfigs(config.ipListSourceConfigs());
        ipRangeListSourceConfigs(config.ipRangeListSourceConfigs());
        cidrListSourceConfigs(config.cidrListSourceConfigs());
        ipCheckerConfigs(config.ipCheckerConfigs());
    }

    protected AbstractJrbldConfigBuilder(
        final IniConfig config,
        final JrbldConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
        IniConfig checkSourcesSection = config.section("check-source");
        enableCheckersStaters = ENABLE_CHECKERS_STATERS.extract(
            checkSourcesSection,
            defaults.enableCheckersStaters());

        Map<String, IniConfig> infoSources =
            config.section("info-source").sections();
        jniInfoSourceConfigs = new HashMap<>(infoSources.size() << 1);
        for (Map.Entry<String, IniConfig> entry: infoSources.entrySet()) {
            IniConfig section = entry.getValue();
            section.getEnum(JrbldInfoSourceType.class, TYPE)
                .loadInfoSourceConfig(this, entry.getKey(), section);
        }

        Map<String, IniConfig> checkSources = checkSourcesSection.sections();
        luceneSourceConfigs = new HashMap<>(checkSources.size() << 1);
        ipListSourceConfigs = new HashMap<>(checkSources.size() << 1);
        ipRangeListSourceConfigs =
            new HashMap<>(checkSources.size() << 1);
        cidrListSourceConfigs = new HashMap<>(checkSources.size() << 1);
        for (Map.Entry<String, IniConfig> entry: checkSources.entrySet()) {
            IniConfig section = entry.getValue();
            section.getEnum(JrbldCheckSourceType.class, TYPE)
                .loadConfig(this, entry.getKey(), section);
        }

        Map<String, IniConfig> checkers = config.section("checker").sections();
        ipCheckerConfigs = new HashMap<>(checkers.size() << 1);
        for (Map.Entry<String, IniConfig> entry: checkers.entrySet()) {
            ipCheckerConfigs.put(
                entry.getKey(),
                new IpCheckerConfigBuilder(entry.getValue()));
        }
    }

    @Override
    public boolean enableCheckersStaters() {
        return enableCheckersStaters;
    }

    public T enableCheckersStaters(final boolean enableCheckersStaters) {
        this.enableCheckersStaters = enableCheckersStaters;
        return self();
    }

    @Override
    public Map<String, JniWrapperConfigBuilder> jniInfoSourceConfigs() {
        return jniInfoSourceConfigs;
    }

    public T jniInfoSourceConfigs(
        final Map<String, ? extends JniWrapperConfig> jniInfoSourceConfigs)
    {
        this.jniInfoSourceConfigs =
            new HashMap<>(jniInfoSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends JniWrapperConfig> entry
            : jniInfoSourceConfigs.entrySet())
        {
            this.jniInfoSourceConfigs.put(
                entry.getKey(),
                new JniWrapperConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public Map<String, LuceneSourceConfigBuilder> luceneSourceConfigs() {
        return luceneSourceConfigs;
    }

    public T luceneSourceConfigs(
        final Map<String, ? extends LuceneSourceConfig> luceneSourceConfigs)
    {
        this.luceneSourceConfigs =
            new HashMap<>(luceneSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends LuceneSourceConfig> entry
            : luceneSourceConfigs.entrySet())
        {
            this.luceneSourceConfigs.put(
                entry.getKey(),
                new LuceneSourceConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public Map<String, IpListSourceConfigBuilder>
        ipListSourceConfigs()
    {
        return ipListSourceConfigs;
    }

    public T ipListSourceConfigs(
        final Map<String, ? extends IpListSourceConfig> ipListSourceConfigs)
    {
        this.ipListSourceConfigs =
            new HashMap<>(ipListSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends IpListSourceConfig> entry
            : ipListSourceConfigs.entrySet())
        {
            this.ipListSourceConfigs.put(
                entry.getKey(),
                new IpListSourceConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public Map<String, IpRangeListSourceConfigBuilder>
        ipRangeListSourceConfigs()
    {
        return ipRangeListSourceConfigs;
    }

    public T ipRangeListSourceConfigs(
        final Map<String, ? extends IpRangeListSourceConfig>
            ipRangeListSourceConfigs)
    {
        this.ipRangeListSourceConfigs =
            new HashMap<>(ipRangeListSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends IpRangeListSourceConfig> entry
            : ipRangeListSourceConfigs.entrySet())
        {
            this.ipRangeListSourceConfigs.put(
                entry.getKey(),
                new IpRangeListSourceConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public Map<String, CidrListSourceConfigBuilder> cidrListSourceConfigs() {
        return cidrListSourceConfigs;
    }

    public T cidrListSourceConfigs(
        final Map<String, ? extends CidrListSourceConfig>
            cidrListSourceConfigs)
    {
        this.cidrListSourceConfigs =
            new HashMap<>(cidrListSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends CidrListSourceConfig> entry
            : cidrListSourceConfigs.entrySet())
        {
            this.cidrListSourceConfigs.put(
                entry.getKey(),
                new CidrListSourceConfigBuilder(entry.getValue()));
        }
        return self();
    }

    @Override
    public Map<String, IpCheckerConfigBuilder> ipCheckerConfigs() {
        return ipCheckerConfigs;
    }

    public T ipCheckerConfigs(
        final Map<String, ? extends IpCheckerConfig> ipCheckerConfigs)
    {
        this.ipCheckerConfigs = new HashMap<>(ipCheckerConfigs.size() << 1);
        for (Map.Entry<String, ? extends IpCheckerConfig> entry
            : ipCheckerConfigs.entrySet())
        {
            this.ipCheckerConfigs.put(
                entry.getKey(),
                new IpCheckerConfigBuilder(entry.getValue()));
        }
        return self();
    }
}

