package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractLuceneSourceConfigBuilder
    <T extends AbstractLuceneSourceConfigBuilder<T>>
    implements LuceneSourceConfig
{
    private int value;
    private String query;
    private String service;
    private long maxPrefix;
    private Long failoverDelay;

    protected AbstractLuceneSourceConfigBuilder(final LuceneSourceConfig config) {
        value(config.value());
        query(config.query());
        service(config.service());
        maxPrefix(config.maxPrefix());
        failoverDelay(config.failoverDelay());
    }

    protected AbstractLuceneSourceConfigBuilder(
        final IniConfig config,
        final LuceneSourceConfig defaults)
        throws ConfigException
    {
        value = JrbldConfig.VALUE.extract(config, defaults.value());
        query = QUERY.extract(config, defaults.query());
        service = SERVICE.extract(config, defaults.service());
        maxPrefix = MAX_PREFIX.extract(config, defaults.maxPrefix());
        failoverDelay =
            FAILOVER_DELAY.extract(config, defaults.failoverDelay());
    }

    protected abstract T self();

    @Override
    public int value() {
        return value;
    }

    public T value(final int value) {
        this.value = value;
        return self();
    }

    @Override
    public String query() {
        return query;
    }

    public T query(final String query) {
        this.query = query;
        return self();
    }

    @Override
    public String service() {
        return service;
    }

    public T service(final String service) {
        this.service = service;
        return self();
    }

    @Override
    public long maxPrefix() {
        return maxPrefix;
    }

    public T maxPrefix(final long maxPrefix) {
        this.maxPrefix = maxPrefix;
        return self();
    }

    @Override
    public Long failoverDelay() {
        return failoverDelay;
    }

    public T failoverDelay(final Long failoverDelay) {
        this.failoverDelay = failoverDelay;
        return self();
    }
}

