package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class CidrListSourceConfigBuilder
    extends AbstractCidrListSourceConfigBuilder<
        CidrListSourceConfigBuilder>
{
    public CidrListSourceConfigBuilder() {
        super(CidrListSourceConfigDefaults.INSTANCE);
    }

    public CidrListSourceConfigBuilder(final CidrListSourceConfig config) {
        super(config);
    }

    public CidrListSourceConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, CidrListSourceConfigDefaults.INSTANCE);
    }

    public CidrListSourceConfigBuilder(
        final IniConfig config,
        final CidrListSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public CidrListSourceConfigBuilder self() {
        return this;
    }

    public ImmutableCidrListSourceConfig build() throws ConfigException {
        return new ImmutableCidrListSourceConfig(this);
    }
}

