package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.util.ip.ImmutableIpRangeListConfig;

public class ImmutableIpRangeListSourceConfig
    extends ImmutableIpRangeListConfig
    implements IpRangeListSourceConfig
{
    private final int value;

    public ImmutableIpRangeListSourceConfig(
        final IpRangeListSourceConfig config)
        throws ConfigException
    {
        super(config);
        value = JrbldConfig.VALUE.validate(config.value());
    }

    @Override
    public int value() {
        return value;
    }
}

