package ru.yandex.mail.so.jrbld.config;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

import ru.yandex.jniwrapper.ImmutableJniWrapperConfig;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.ImmutableUniversalSearchProxyConfig;

public class ImmutableJrbldConfig
    extends ImmutableUniversalSearchProxyConfig
    implements JrbldConfig
{
    private final boolean enableCheckersStaters;
    private final Map<String, ImmutableJniWrapperConfig> jniInfoSourceConfigs;
    private final Map<String, ImmutableLuceneSourceConfig> luceneSourceConfigs;
    private final Map<String, ImmutableIpListSourceConfig> ipListSourceConfigs;
    private final Map<String, ImmutableIpRangeListSourceConfig>
        ipRangeListSourceConfigs;
    private final Map<String, ImmutableCidrListSourceConfig>
        cidrListSourceConfigs;
    private final Map<String, ImmutableIpCheckerConfig> ipCheckerConfigs;

    public ImmutableJrbldConfig(final JrbldConfig config)
        throws ConfigException
    {
        super(config);
        enableCheckersStaters =
            ENABLE_CHECKERS_STATERS.validate(config.enableCheckersStaters());
        Map<String, ? extends JniWrapperConfig> jniInfoSourceConfigs =
            config.jniInfoSourceConfigs();
        this.jniInfoSourceConfigs =
            new HashMap<>(jniInfoSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends JniWrapperConfig> entry
            : jniInfoSourceConfigs.entrySet())
        {
            this.jniInfoSourceConfigs.put(
                entry.getKey(),
                new ImmutableJniWrapperConfig(entry.getValue()));
        }

        Map<String, ? extends LuceneSourceConfig> luceneSourceConfigs =
            config.luceneSourceConfigs();
        this.luceneSourceConfigs =
            new HashMap<>(luceneSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends LuceneSourceConfig> entry
            : luceneSourceConfigs.entrySet())
        {
            this.luceneSourceConfigs.put(
                entry.getKey(),
                new ImmutableLuceneSourceConfig(entry.getValue()));
        }

        Map<String, ? extends IpListSourceConfig> ipListSourceConfigs =
            config.ipListSourceConfigs();
        this.ipListSourceConfigs =
            new HashMap<>(ipListSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends IpListSourceConfig> entry
            : ipListSourceConfigs.entrySet())
        {
            this.ipListSourceConfigs.put(
                entry.getKey(),
                new ImmutableIpListSourceConfig(entry.getValue()));
        }

        Map<String, ? extends IpRangeListSourceConfig>
            ipRangeListSourceConfigs = config.ipRangeListSourceConfigs();
        this.ipRangeListSourceConfigs =
            new HashMap<>(ipRangeListSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends IpRangeListSourceConfig> entry
            : ipRangeListSourceConfigs.entrySet())
        {
            this.ipRangeListSourceConfigs.put(
                entry.getKey(),
                new ImmutableIpRangeListSourceConfig(entry.getValue()));
        }

        Map<String, ? extends CidrListSourceConfig> cidrListSourceConfigs =
            config.cidrListSourceConfigs();
        this.cidrListSourceConfigs =
            new HashMap<>(cidrListSourceConfigs.size() << 1);
        for (Map.Entry<String, ? extends CidrListSourceConfig> entry
            : cidrListSourceConfigs.entrySet())
        {
            this.cidrListSourceConfigs.put(
                entry.getKey(),
                new ImmutableCidrListSourceConfig(entry.getValue()));
        }

        Set<String> knownSources =
            new HashSet<>(this.luceneSourceConfigs.keySet());
        knownSources.addAll(this.ipListSourceConfigs.keySet());
        knownSources.addAll(this.ipRangeListSourceConfigs.keySet());
        knownSources.addAll(this.cidrListSourceConfigs.keySet());
        Map<String, ? extends IpCheckerConfig> ipCheckerConfigs =
            config.ipCheckerConfigs();
        this.ipCheckerConfigs = new HashMap<>(ipCheckerConfigs.size() << 1);
        for (Map.Entry<String, ? extends IpCheckerConfig> entry
            : ipCheckerConfigs.entrySet())
        {
            String checkerName = entry.getKey();
            ImmutableIpCheckerConfig checkerConfig =
                new ImmutableIpCheckerConfig(entry.getValue());
            for (String name: checkerConfig.sources()) {
                if (!knownSources.contains(name)) {
                    throw new ConfigException(
                        "Unknown source name: " + name
                        + " for checker " + checkerName);
                }
            }
            this.ipCheckerConfigs.put(checkerName, checkerConfig);
            knownSources.add(checkerName);
        }

        Set<String> sources =
            new HashSet<>(this.jniInfoSourceConfigs.keySet());
        checkDuplicates(sources, this.luceneSourceConfigs.keySet());
        checkDuplicates(sources, this.ipListSourceConfigs.keySet());
        checkDuplicates(sources, this.ipRangeListSourceConfigs.keySet());
        checkDuplicates(sources, this.cidrListSourceConfigs.keySet());
        checkDuplicates(sources, this.ipCheckerConfigs.keySet());
    }

    private static void checkDuplicates(
        final Set<String> allNames,
        final Set<String> newNames)
        throws ConfigException
    {
        for (String name: newNames) {
            if (!allNames.add(name)) {
                throw new ConfigException("Duplicated source name: " + name);
            }
        }
    }

    @Override
    public boolean enableCheckersStaters() {
        return enableCheckersStaters;
    }

    @Override
    public Map<String, ImmutableJniWrapperConfig> jniInfoSourceConfigs() {
        return jniInfoSourceConfigs;
    }

    @Override
    public Map<String, ImmutableLuceneSourceConfig> luceneSourceConfigs() {
        return luceneSourceConfigs;
    }

    @Override
    public Map<String, ImmutableIpListSourceConfig> ipListSourceConfigs() {
        return ipListSourceConfigs;
    }

    @Override
    public Map<String, ImmutableIpRangeListSourceConfig>
        ipRangeListSourceConfigs()
    {
        return ipRangeListSourceConfigs;
    }

    @Override
    public Map<String, ImmutableCidrListSourceConfig> cidrListSourceConfigs() {
        return cidrListSourceConfigs;
    }

    @Override
    public Map<String, ImmutableIpCheckerConfig> ipCheckerConfigs() {
        return ipCheckerConfigs;
    }
}

