package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;

public class ImmutableLuceneSourceConfig implements LuceneSourceConfig {
    private final int value;
    private final String query;
    private final String service;
    private final long maxPrefix;
    private final Long failoverDelay;

    public ImmutableLuceneSourceConfig(final LuceneSourceConfig config)
        throws ConfigException
    {
        value = JrbldConfig.VALUE.validate(config.value());
        query = QUERY.validate(config.query());
        service = SERVICE.validate(config.service());
        maxPrefix = MAX_PREFIX.validate(config.maxPrefix());
        failoverDelay = FAILOVER_DELAY.validate(config.failoverDelay());
    }

    @Override
    public int value() {
        return value;
    }

    @Override
    public String query() {
        return query;
    }

    @Override
    public String service() {
        return service;
    }

    @Override
    public long maxPrefix() {
        return maxPrefix;
    }

    @Override
    public Long failoverDelay() {
        return failoverDelay;
    }
}

