package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IpCheckerConfigBuilder
    extends AbstractIpCheckerConfigBuilder<IpCheckerConfigBuilder>
{
    public IpCheckerConfigBuilder() {
        super(IpCheckerConfigDefaults.INSTANCE);
    }

    public IpCheckerConfigBuilder(final IpCheckerConfig config) {
        super(config);
    }

    public IpCheckerConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, IpCheckerConfigDefaults.INSTANCE);
    }

    public IpCheckerConfigBuilder(
        final IniConfig config,
        final IpCheckerConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public IpCheckerConfigBuilder self() {
        return this;
    }

    public ImmutableIpCheckerConfig build()
        throws ConfigException
    {
        return new ImmutableIpCheckerConfig(this);
    }
}

