package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IpListSourceConfigBuilder
    extends AbstractIpListSourceConfigBuilder<
        IpListSourceConfigBuilder>
{
    public IpListSourceConfigBuilder() {
        super(IpListSourceConfigDefaults.INSTANCE);
    }

    public IpListSourceConfigBuilder(final IpListSourceConfig config) {
        super(config);
    }

    public IpListSourceConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, IpListSourceConfigDefaults.INSTANCE);
    }

    public IpListSourceConfigBuilder(
        final IniConfig config,
        final IpListSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public IpListSourceConfigBuilder self() {
        return this;
    }

    public ImmutableIpListSourceConfig build() throws ConfigException {
        return new ImmutableIpListSourceConfig(this);
    }
}

