package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class IpRangeListSourceConfigBuilder
    extends AbstractIpRangeListSourceConfigBuilder<
        IpRangeListSourceConfigBuilder>
{
    public IpRangeListSourceConfigBuilder() {
        super(IpRangeListSourceConfigDefaults.INSTANCE);
    }

    public IpRangeListSourceConfigBuilder(
        final IpRangeListSourceConfig config)
    {
        super(config);
    }

    public IpRangeListSourceConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, IpRangeListSourceConfigDefaults.INSTANCE);
    }

    public IpRangeListSourceConfigBuilder(
        final IniConfig config,
        final IpRangeListSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public IpRangeListSourceConfigBuilder self() {
        return this;
    }

    public ImmutableIpRangeListSourceConfig build() throws ConfigException {
        return new ImmutableIpRangeListSourceConfig(this);
    }
}

