package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum JrbldCheckSourceType {
    LUCENE {
        @Override
        public void loadConfig(
            final AbstractJrbldConfigBuilder<?> config,
            final String name,
            final IniConfig section)
            throws ConfigException
        {
            config.luceneSourceConfigs().put(
                name,
                new LuceneSourceConfigBuilder(section));
        }
    },
    IP_LIST {
        @Override
        public void loadConfig(
            final AbstractJrbldConfigBuilder<?> config,
            final String name,
            final IniConfig section)
            throws ConfigException
        {
            config.ipListSourceConfigs().put(
                name,
                new IpListSourceConfigBuilder(section));
        }
    },
    IP_RANGE_LIST {
        @Override
        public void loadConfig(
            final AbstractJrbldConfigBuilder<?> config,
            final String name,
            final IniConfig section)
            throws ConfigException
        {
            config.ipRangeListSourceConfigs().put(
                name,
                new IpRangeListSourceConfigBuilder(section));
        }
    },
    CIDR_LIST {
        @Override
        public void loadConfig(
            final AbstractJrbldConfigBuilder<?> config,
            final String name,
            final IniConfig section)
            throws ConfigException
        {
            config.cidrListSourceConfigs().put(
                name,
                new CidrListSourceConfigBuilder(section));
        }
    };

    public abstract void loadConfig(
        final AbstractJrbldConfigBuilder<?> config,
        final String name,
        final IniConfig section)
        throws ConfigException;
}

