package ru.yandex.mail.so.jrbld.config;

import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.jniwrapper.JniWrapperConfig;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.BooleanParser;
import ru.yandex.parser.string.PositiveValidator;
import ru.yandex.search.proxy.universal.UniversalSearchProxyConfig;

public interface JrbldConfig extends UniversalSearchProxyConfig {
    ParameterConfig<Integer> VALUE = new ParameterConfig<>(
        "value",
        Integer::valueOf,
        PositiveValidator.instance());
    ParameterConfig<Boolean> ENABLE_CHECKERS_STATERS = new ParameterConfig<>(
        "enable-checkers-staters",
        BooleanParser.INSTANCE,
        GenericFunction.identity());

    boolean enableCheckersStaters();

    Map<String, ? extends JniWrapperConfig> jniInfoSourceConfigs();

    Map<String, ? extends LuceneSourceConfig> luceneSourceConfigs();

    Map<String, ? extends IpListSourceConfig> ipListSourceConfigs();

    Map<String, ? extends IpRangeListSourceConfig> ipRangeListSourceConfigs();

    Map<String, ? extends CidrListSourceConfig> cidrListSourceConfigs();

    Map<String, ? extends IpCheckerConfig> ipCheckerConfigs();
}

