package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class JrbldConfigBuilder
    extends AbstractJrbldConfigBuilder<JrbldConfigBuilder>
{
    public JrbldConfigBuilder() {
        super(JrbldConfigDefaults.INSTANCE);
    }

    public JrbldConfigBuilder(final JrbldConfig config) {
        super(config);
    }

    public JrbldConfigBuilder(
        final IniConfig config)
        throws ConfigException
    {
        this(config, JrbldConfigDefaults.INSTANCE);
    }

    public JrbldConfigBuilder(
        final IniConfig config,
        final JrbldConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public JrbldConfigBuilder self() {
        return this;
    }

    public ImmutableJrbldConfig build() throws ConfigException {
        return new ImmutableJrbldConfig(this);
    }
}

