package ru.yandex.mail.so.jrbld.config;

import ru.yandex.jniwrapper.JniWrapperConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public enum JrbldInfoSourceType {
    JNI {
        @Override
        public void loadInfoSourceConfig(
            final AbstractJrbldConfigBuilder<?> config,
            final String name,
            final IniConfig section)
            throws ConfigException
        {
            config.jniInfoSourceConfigs().put(
                name,
                new JniWrapperConfigBuilder(section));
        }
    };

    public abstract void loadInfoSourceConfig(
        final AbstractJrbldConfigBuilder<?> config,
        final String name,
        final IniConfig section)
        throws ConfigException;
}

