package ru.yandex.mail.so.jrbld.config;

import ru.yandex.function.GenericFunction;
import ru.yandex.function.NullToDefaultFunction;
import ru.yandex.parser.config.ParameterConfig;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.string.NonNegativeValidator;
import ru.yandex.parser.string.PositiveValidator;

public interface LuceneSourceConfig extends IpCheckerValueConfig {
    ParameterConfig<String> QUERY = new ParameterConfig<>(
        "query",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<String> SERVICE = new ParameterConfig<>(
        "service",
        GenericFunction.identity(),
        NonEmptyValidator.INSTANCE);
    ParameterConfig<Long> MAX_PREFIX = new ParameterConfig<>(
        "max-prefix",
        Long::valueOf,
        PositiveValidator.instance());
    ParameterConfig<Long> FAILOVER_DELAY = new ParameterConfig<>(
        "failover-delay",
        DurationParser.LONG,
        new NullToDefaultFunction<>(NonNegativeValidator.instance()),
        true);

    String query();

    String service();

    long maxPrefix();

    Long failoverDelay();
}

