package ru.yandex.mail.so.jrbld.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public class LuceneSourceConfigBuilder
    extends AbstractLuceneSourceConfigBuilder<
        LuceneSourceConfigBuilder>
{
    public LuceneSourceConfigBuilder() {
        super(LuceneSourceConfigDefaults.INSTANCE);
    }

    public LuceneSourceConfigBuilder(final LuceneSourceConfig config) {
        super(config);
    }

    public LuceneSourceConfigBuilder(final IniConfig config)
        throws ConfigException
    {
        this(config, LuceneSourceConfigDefaults.INSTANCE);
    }

    public LuceneSourceConfigBuilder(
        final IniConfig config,
        final LuceneSourceConfig defaults)
        throws ConfigException
    {
        super(config, defaults);
    }

    @Override
    public LuceneSourceConfigBuilder self() {
        return this;
    }

    public ImmutableLuceneSourceConfig build() throws ConfigException {
        return new ImmutableLuceneSourceConfig(this);
    }
}

