#!/bin/bash
set -exo pipefail

source jrbld_config_base.sh

export DATA_DIR=/data
export ZOO_CLIENT_PORT=$QUEUE_CLIENT_PORT
export ZOO_HTTP_PORT=$QUEUE_HTTP_PORT
export ZOO_VOTE_PORT=$QUEUE_VOTE_PORT
export ZOO_DATA_PORT=$QUEUE_DATA_PORT
export CONC_GC_THREADS=3
export ADDITIONAL_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-Dzoolooser.traffic-compress.zstd=false
-Dzoolooser.disable-write-limiter=true
-Dru.yandex.lucene.default-cache-size=48000000
-Dru.yandex.lucene.fsync-bytes-interval=100000000
-Dru.yandex.lucene.quiet-stderr=true
-Dru.yandex.lucene-storage.codec=Yandex2_lz4
-Dru.yandex.lucene-storage.codec-compression-level=9
-Dru.yandex.lucene-storage.group-fields=_GROUP_NONE_
-Dru.yandex.lucene-storage.index-threads=3
-Dru.yandex.lucene-storage.merge-threads=4
-Dru.yandex.lucene-storage.max-live-data-size=48000000
-Dru.yandex.lucene-storage.max-cache-weight=48000000
-Dru.yandex.lucene-storage.max-segment-size=$((128 * 1024 * 1024))
-Dru.yandex.lucene-queue.ram-buffer-size-mb=48
-Dru.yandex.lucene-storage.zoo-hash-bloom-filter=false
-Dru.yandex.lucene-storage.in-memory-fields-index=false"
export MEMORY_GAP=$((1024*1024*1024))
