package ru.yandex.mail.so.jrbld.launcher;

import ru.yandex.collection.Pattern;
import ru.yandex.dispatcher.consumer.ConsumerServer;
import ru.yandex.dispatcher.consumer.ConsumerServerFactory;
import ru.yandex.dispatcher.producer.PostDataHandler;
import ru.yandex.dispatcher.producer.Producer;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.server.DefaultHttpServerFactory;
import ru.yandex.http.util.server.HttpServer;
import ru.yandex.mail.so.jrbld.Jrbld;
import ru.yandex.msearch.Daemon;
import ru.yandex.stater.PrefixingStater;

public final class JrbldLauncher {
    private JrbldLauncher() {
    }

    public static void main(final String... args) {
        int idx = 0;
        try {
            Producer producer =
                Producer.class.cast(
                    Producer.main(
                        new DefaultHttpServerFactory<>(Producer.class),
                        args[idx++]));
            RblUpdateHandler rblUpdateHandler =
                new RblUpdateHandler(new PostDataHandler(producer));
            producer.register(
                new Pattern<>("/add", true),
                rblUpdateHandler,
                RequestHandlerMapper.GET);
            producer.register(
                new Pattern<>("/modify", true),
                rblUpdateHandler,
                RequestHandlerMapper.GET);
            producer.register(
                new Pattern<>("/delete", true),
                rblUpdateHandler,
                RequestHandlerMapper.GET);
            Daemon daemon = Daemon.createDaemon(args[idx++]);
            HttpServer<?, ?> jrbld = Jrbld.main(
                new DefaultHttpServerFactory<>(Jrbld.class),
                args[idx++]);
            HttpServer<?, ?> consumer = ConsumerServer.main(
                new ConsumerServerFactory(),
                args[idx]);
            jrbld.registerStater(
                new PrefixingStater("producer-", producer));
            jrbld.registerStater(
                new PrefixingStater("consumer-", consumer));
            jrbld.registerStater(
                new PrefixingStater("searcher-", daemon.httpSearchServer()));
            jrbld.registerStater(
                new PrefixingStater("indexer-", daemon.jsonIndexerServer()));
        } catch (Throwable t) {
            t.printStackTrace();
            System.exit(-1);
        }
    }
}

