package ru.yandex.mail.so.jrbld.launcher;

import java.io.IOException;
import java.net.InetAddress;

import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.nio.entity.NStringEntity;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestConsumer;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.util.ServiceUnavailableException;
import ru.yandex.http.util.YandexHeaders;
import ru.yandex.http.util.nio.FilterHttpAsyncExchange;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.io.StringBuilderWriter;
import ru.yandex.json.writer.JsonType;
import ru.yandex.json.writer.JsonWriter;
import ru.yandex.parser.string.DurationParser;
import ru.yandex.parser.string.NonEmptyValidator;
import ru.yandex.parser.uri.CgiParams;
import ru.yandex.parser.uri.UriParser;
import ru.yandex.util.string.StringUtils;
import ru.yandex.util.timesource.TimeSource;

public class RblUpdateHandler
    implements HttpAsyncRequestHandler<HttpRequest>
{
    private static final long INT_MASK = 0xffffffffL;
    private static final long SHARDS = 7L;

    private final HttpAsyncRequestHandler<HttpRequest> next;

    public RblUpdateHandler(final HttpAsyncRequestHandler<HttpRequest> next) {
        this.next = next;
    }

    @Override
    public HttpAsyncRequestConsumer<HttpRequest> processRequest(
        final HttpRequest request,
        final HttpContext context)
        throws HttpException, IOException
    {
        return next.processRequest(request, context);
    }

    @Override
    public void handle(
        final HttpRequest request,
        final HttpAsyncExchange exchange,
        final HttpContext context)
        throws HttpException
    {
        String uri = request.getRequestLine().getUri();
        UriParser uriParser = new UriParser(uri);
        CgiParams params = new CgiParams(uriParser.queryParser());
        String rblType = params.get("rbl-type", NonEmptyValidator.TRIMMED);
        StringBuilderWriter sbw = new StringBuilderWriter();
        try (JsonWriter writer = JsonType.DOLLAR.create(sbw)) {
            writer.startObject();
            writer.key("prefix");
            InetAddress address = params.get("ip", InetAddress::getByName);
            String hostAddress = address.getHostAddress();
            long prefix = (address.hashCode() & INT_MASK) % SHARDS;
            writer.value(prefix);
            writer.key("docs");
            writer.startArray();
            writer.startObject();
            writer.key("id");
            writer.value(
                StringUtils.concat("rbl_", rblType, '_', hostAddress));
            if (!uriParser.path().decode().startsWith("/delete")) {
                writer.key("rbl_ip");
                writer.value(hostAddress);
                writer.key("rbl_type");
                writer.value(rblType);
                long ttl = params.get("ttl", DurationParser.POSITIVE_LONG);
                writer.key("rbl_expire_timestamp");
                writer.value(TimeSource.INSTANCE.currentTimeMillis() + ttl);
            }
            writer.endObject();
            writer.endArray();
            writer.endObject();
            BasicHttpEntityEnclosingRequest nextRequest =
                new BasicHttpEntityEnclosingRequest(
                    RequestHandlerMapper.POST,
                    uri);
            nextRequest.setEntity(
                new NStringEntity(
                    sbw.toString(),
                    ContentType.APPLICATION_JSON));
            nextRequest.setHeader(YandexHeaders.SERVICE, "rbl");
            nextRequest.setHeader(
                YandexHeaders.ZOO_SHARD_ID,
                Long.toString(prefix));
            next.handle(
                nextRequest,
                new OverridenRequestExchange(exchange, nextRequest),
                context);
        } catch (IOException e) {
            throw new ServiceUnavailableException(e);
        }
    }

    private static class OverridenRequestExchange
        extends FilterHttpAsyncExchange
    {
        private final HttpRequest request;

        OverridenRequestExchange(
            final HttpAsyncExchange exchange,
            final HttpRequest request)
        {
            super(exchange);
            this.request = request;
        }

        @Override
        public HttpRequest getRequest() {
            return request;
        }
    }
}

