#!/bin/bash
set -exo pipefail

source config.sh

source classpath.sh

export CPU_CORES=$(echo $CPU_LIMIT | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
export MEMORY_LIMIT=$(echo $MEM_LIMIT | gawk '{print int($1*0.8)}')

GB=$(( 1024*1024*1024 ))
GB0_5=$(( GB / 2 ))
export MEMORY_GAP=${MEMORY_GAP:-$GB0_5}
XMX=$(( (MEMORY_LIMIT - MEMORY_GAP) / 1048576))

GC_ARGS="
-XX:+DisableExplicitGC
-Xlog:gc*:/dev/shm/gc.log
-XX:+UnlockExperimentalVMOptions
-XX:+UseG1GC
-Xmx${XMX}M
-Xms512M
-Xmn512M
-XX:ParallelGCThreads=$CPU_CORES
-XX:ConcGCThreads=1
-XX:G1ConcRefinementThreads=1
-XX:MaxGCPauseMillis=50
-XX:G1MixedGCCountTarget=32
-XX:G1HeapWastePercent=20
-XX:G1AdaptiveIHOPNumInitialSamples=10
-XX:+PrintGCDetails
"
ADDITIONAL_ARGS="-DPORTO=1 -XX:ActiveProcessorCount=$CPU_CORES -Dru.yandex.dispatcher-zk.reconnect-threads=4"

LD_LIBRARY_PATH=$JAVA_LD_LIBRARY_PATH LD_PRELOAD=$JAVA_LD_PRELOAD exec \
    $BSCONFIG_IDIR/jdk/bin/java \
    $NET_ARGS $GC_ARGS $ADDITIONAL_ARGS \
    -Djava.library.path=jrbld_service \
    -cp $CLASSPATH ru.yandex.mail.so.jrbld.launcher.JrbldLauncher \
    producer.conf \
    search_backend.conf \
    jrbld.conf \
    consumer.conf

