import logging

from aiohttp import ClientSession
from mail.so.libs.python.cast import to_longlong

logger = logging.Logger("ban")


class Ban:
    def __init__(self, shingle_type: int, shingle: int, weight: float, duration: float):
        self.shingle_type = shingle_type
        self.shingle = shingle
        self.weight = weight
        self.duration = duration

    def to_request(self):
        return [
            {
                "type": "SyncUpdate",
                "scheme": "user_weights",
                "fields": [{
                    "shingle": to_longlong(self.shingle),
                    "type": self.shingle_type,
                    "win_weight": self.weight,
                    "win_during": self.duration,
                    "win_user": 'bot',
                    "win_setwghtcnt": 1,
                    "should_be_malic_in": 0,

                    "wout_weight": 0,
                    "wout_during": 0,
                    "wout_user": 'bot',
                    "wout_setwghtcnt": 0,
                    "should_be_malic_out": 0,
                }]
            }
        ]

    async def ban(self, url, retries):
        logger.info(f"try ban {self.shingle_type} {self.shingle} {self.weight} {self.duration}")
        retries = max(1, retries)
        async with ClientSession() as session:
            while retries > 0:
                retries -= 1
                async with session.post(url, json=self.to_request()) as resp:
                    if resp.status == 200:
                        logger.info(f"baned {self.shingle_type} {self.shingle} {self.weight} {self.duration}")
                        return
                    if retries == 0:
                        resp.raise_for_status()
