class Builder:
    def __init__(self, limit):
        self._limit = limit
        self._parts = []
        self._len = 0

    def add(self, s: str):
        if self._len + len(s) <= self._limit:
            self._parts.append(s)
            self._len += len(s)

    def __iadd__(self, s: str):
        self.add(s)
        return self

    def build(self) -> str:
        return "".join(self._parts)
