import os

from selenium import webdriver
from selenium.webdriver.common.by import By
from selenium.webdriver.support import expected_conditions as ec
from selenium.webdriver.support.ui import WebDriverWait


class ScreenShooter:
    def __init__(self, path_to_chrome, path_to_driver, working_dir, render_timeout=30):
        self.options = webdriver.ChromeOptions()
        self.options.binary_location = path_to_chrome
        self.options.add_argument('--headless')
        self.options.add_argument('--start-maximized')
        self.options.add_argument('--no-sandbox')
        self.path_to_driver = path_to_driver
        self.working_dir = working_dir
        self.render_timeout = render_timeout
        self.browser = webdriver.Chrome(self.path_to_driver, chrome_options=self.options)
        self.browser.maximize_window()

    async def save_screenshot(self, url, path_to_save):
        self.browser.get(url)
        element = WebDriverWait(self.browser, self.render_timeout).until(
            ec.presence_of_element_located((By.TAG_NAME, "div"))
        )

        self.browser.set_window_size(1920, element.size["height"] + 1000)  # the trick

        image_path = os.path.join(self.working_dir, path_to_save)
        self.browser.save_screenshot(image_path)

        return image_path
