import logging

from aiohttp import ClientSession

from .user_validator import Validator

logger = logging.getLogger("staff_validator")


class StaffValidator(Validator):
    def __init__(self, oauth_token: str):
        self.oauth_token = oauth_token
        assert self.oauth_token

    async def valid(self, username: str) -> bool:
        if not username:
            return False
        async with ClientSession() as session:
            async with session.get(
                f'https://staff-api.yandex-team.ru/v3/persons?'
                f'_one=1&'
                f'_fields=login&'
                f'accounts.type=telegram&'
                f'accounts.value="{username}"',
                headers={"Authorization": f"OAuth {self.oauth_token}"}
            ) as resp:
                data = await resp.json()
                logger.info(f"staff for {username}: {data}")
                if resp.status != 200:
                    logger.error(f"{resp.status}, {data}")
                    return False

                return 'login' in data
