import datetime


class Timeline:
    def __init__(self, tl):
        self.dt = datetime.datetime.strptime(tl["dt"], "%Y-%m-%d %H")

        self.top_froms = [v[1] for v in tl["top_froms"]]
        self.top_subjs = [v[1] for v in tl["top_subjs"]]

    def __lt__(self, other: "Timeline") -> bool:
        return self.dt < other.dt

    def __str__(self):
        return f"*{self.dt.strftime('%Y-%m-%d %H')}*\n" + "\n".join(
            f"`{top_subj}: {top_from}`" for top_from, top_subj in
            zip(self.top_froms, self.top_subjs))

    def __hash__(self):
        return hash(self.dt)

    def __eq__(self, other: "Timeline"):
        return self.dt == other.dt and self.top_subjs == other.top_subjs and self.top_froms == other.top_froms
