import ticket_parser2.api.v1 as tp2
from aiohttp.web import HTTPUnauthorized
from multidict import CIMultiDictProxy


class TvmClient:
    def __init__(self, self_id, secret, bb_id, allowed_consumers):
        self._client = tp2.TvmClient(tp2.TvmApiClientSettings(
            self_client_id=self_id,
            enable_service_ticket_checking=True,
            enable_user_ticket_checking=tp2.BlackboxEnv.Prod if bb_id == 222 else tp2.BlackboxEnv.Test,
            self_secret=secret,
            dsts={"bb": bb_id},
        ))

        self._allowed_consumers = list(allowed_consumers)

    def verify(self, headers: CIMultiDictProxy[str]):
        try:
            service_ticket = headers.get('X-Ya-Service-Ticket')
            if service_ticket:
                st = self._client.check_service_ticket(service_ticket)
                if st.src in self._allowed_consumers:
                    return
                raise HTTPUnauthorized(reason=f"{st.src} is not permitted")

            user_ticket = headers.get('X-Ya-User-Ticket')
            if user_ticket:
                ut = self._client.check_user_ticket(user_ticket)
                if 'allow_to_get_secret_data' in ut.scopes:
                    return
                raise HTTPUnauthorized(reason=f"user scopes are {ut.scopes} doesnt contain 'allow_to_get_secret_data'")

        except HTTPUnauthorized as e:
            raise e
        except Exception as e:
            raise HTTPUnauthorized(reason=str(e))
