import logging
import typing
import uuid

from .ban import Ban

logger = logging.getLogger('view')


class Button:
    def __init__(self, text: str, ban: typing.Optional[Ban] = None):
        self.text = text
        self.ban = ban

    SERIAL_HASH = {}

    def to_string(self):
        h = str(uuid.uuid1())
        Button.SERIAL_HASH[h] = self
        return h

    @classmethod
    def from_string(cls, s: str) -> typing.Optional["Button"]:
        return cls.SERIAL_HASH.get(s, None)

    @classmethod
    def remove(cls, s: str):
        del cls.SERIAL_HASH[s]

    def to_markup(self):
        return {
            "type": "InlineKeyboardButton",
            "text": self.text,
            "callback_data": "button-" + self.to_string(),
        }

    def __eq__(self, other: "Button"):
        return self.text == other.text


FalseButton = Button("False")
LaterButton = Button("Later")


class View:
    def __init__(self, markup, buttons):
        self.markup: str = markup
        self.buttons: [Button] = [button if isinstance(button, Button) else Button(**button) for button in buttons]
