#!/bin/bash
set -exo pipefail

source recommended_java_args.sh

export LOGS_DIR=/logs
export STATE_DIR=/ssd/index
export LJINX_PORT=$BSCONFIG_IPORT
export LUCENE_SEARCH_PORT=$((BSCONFIG_IPORT+3))
export LUCENE_INDEX_PORT=$((BSCONFIG_IPORT+4))

case "$NANNY_SERVICE_ID" in
    ps_cache_global_test*)
        export SERVER_NAME=adele-test.pers.yandex.net
        export OCRAAS_SRW_HOST=ocraas-srw.tst.ape.yandex.net
        export IMAGEPARSER_SRW_HOST=imageparser-srw.tst.ape.yandex.net
        export DJFS_HOST=djfs-api-stable.qloud.dst.yandex.net
        export TIKAITE_SRW_HOST=tikaite.tst.ape.yandex.net
        ;;
    *_ps_cache_global)
        export SERVER_NAME=adele.mail.yandex.net
        export OCRAAS_SRW_HOST=ocraas.ape.yandex.net
        export IMAGEPARSER_SRW_HOST=imageparser.ape.yandex.net
        export DJFS_HOST=djfs-api.qloud.disk.yandex.net
        export TIKAITE_SRW_HOST=tikaite.ape.yandex.net
        ;;
esac

export OCRAAS_SRW_HOST_ESCAPED=$(echo $OCRAAS_SRW_HOST|sed 's/[.]/\\./g')
export IMAGEPARSER_SRW_HOST_ESCAPED=$(echo $IMAGEPARSER_SRW_HOST|sed 's/[.]/\\./g')

