#!/bin/bash
source config.sh
export DEADLINE=$(date +%s)
SHARDS=$(fgrep shards lucene-prod.conf | awk -F '=' '{print int($2)}')
TVM_TICKET=$(tvmknife get_service_ticket client_credentials --dst 2000273 --src 2018890 --secret $MDS_TVM2_SECRET)
seq 0 $((SHARDS-1)) | while read shard
do
    while true;
    do
        curl -s -m 60 "http://localhost:${LUCENE_SEARCH_PORT}/search?prefix=$shard&text=http_expire_timestamp:%5b0+TO+"$DEADLINE"%5d&ljinx-cache-cleanup&get=url,http_body&length=10000&hr" > /logs/delete_batch
        hits=$(jq '.hitsArray[].url' < /logs/delete_batch | wc -l)
        if [ "$hits" == "" -o "$hits" == "0" ]; then
            break;
        fi
        cat /logs/delete_batch | jq -r  '.hitsArray[].http_body + "0A"' | xxd -r -p | \
        awk -v tvm=$TVM_TICKET '{print "storage-int.mds.yandex.net:1111/delete-ps-cache/"$0 }' | \
        xargs -d '\n' -n 200 -P50 curl -s --retry 1 -H "X-Ya-Service-Ticket: $TVM_TICKET"
#        xargs -d '\n' -n 200 -P20 curl -s --retry 2 -H "X-Ya-Service-Ticket: $TVM_TICKET"
        cat /logs/delete_batch | jq -r  '.hitsArray[].url' | \
        awk '{print "localhost:'${LUCENE_INDEX_PORT}'/delete?prefix='$shard'&text=url:"$0}' | \
        xargs -n 300 -P2 curl -s --retry 2
        echo $(date)": Deleted $hits/"$(jq '.hitsCount' < /logs/delete_batch)
    done
done
