#!/bin/bash
set -exo pipefail
source config.sh
source classpath.sh

export INDEX_DIR=${STATE_DIR:-/ssd}
export MTN_TAG=$(hostname -s)

export LD_LIBRARY_PATH=.

export LJINX_PORT=$BSCONFIG_IPORT
export LJINX_CONFIG="$BSCONFIG_IDIR/ljinx-prod.conf"

export LUCENE_FIELDS_CONFIG_DIR=$BSCONFIG_IDIR
export LUCENE_CONFIG="$BSCONFIG_IDIR/lucene-prod.conf"

GB=$(( 1024*1024*1024 ))
GB1_5=$(( GB + (GB / 2) ))
export MEMORY_GAP=${MEMORY_GAP:-$GB}

if [ "$MEM_LIMIT" != "" ]; then
    export MEMORY_LIMIT=$((MEM_LIMIT/100*80))
else
    export MEMORY_LIMIT=$(cat dump.json | jq -r '.container.constraints | .["slot.memory_limit"]' | awk '{print int($1*0.8)}')
fi
if [ "$CPU_LIMIT" != "" ]; then
    export CPU_CORES=$(echo $CPU_LIMIT | awk '{print int($1 - 2)}')
else
    export CPU_CORES=$(cat dump.json | jq -r '.container.constraints | .["slot.cpu_limit"]' | grep -Eo '[0-9\.]+' | awk '{print int($1)}')
fi

XMX=$(( (MEMORY_LIMIT - MEMORY_GAP) / 1048576))
XMS=$(( XMX / 5 ))
XMN=$(( XMS / 5 ))

MEM_ARGS="-Xmx${XMX}M -Xms${XMS}M -Xmn${XMN}M"
GC_ARGS="
-XX:+IgnoreUnrecognizedVMOptions
-XcompilationThreads1
-Xgc:concurrentScavengeBackground=1
-Xgc:concurrentScavenge
-XX:IdleTuningGcOnIdl
-XX:IdleTuningMinIdleWaitTime=1
-Xsoftrefthreshold1000000000
-Xjit:scratchSpaceLimit=$((64*1024))
-Djdk.nio.maxCachedBufferSize=$((256*1024))
-Xgcpolicy:gencon
-verbose:gc
-XX:ActiveProcessorCount=$CPU_CORES
-Xgcthreads$CPU_CORES
-Xconcurrentbackground4
-Xverbosegclog:/dev/shm/gc#.log,5,2000"
DUMP_ARGS="-XX:+HeapDumpOnOutOfMemoryError -XX:HeapDumpPath=$CORE_DIR -XX:+ExitOnOutOfMemoryError"
NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"
LJINX_ARGS="ru.yandex.ljinx.Ljinx ljinx-prod.conf"
LUCENE_ARGS="ru.yandex.msearch.Daemon -config lucene-prod.conf"
exec $BSCONFIG_IDIR/jdk/bin/java \
    $MEM_ARGS $DUMP_ARGS $GC_ARGS $NET_ARGS \
    -Djava.rmi.server.hostname=$BSCONFIG_IHOST \
    -Djava.library.path=ljinx_mds_cache \
    -DPORTO=1 \
    -cp $CLASSPATH ru.yandex.multistarter.MultiStarter \
    $LJINX_ARGS ";" $LUCENE_ARGS
