#!/bin/bash
set -o pipefail

export SERVICE_NAME=$(jq -r ".properties.INSTANCE_TAG_PRJ" ./dump.json)
export LJINX_PORT=${1:-$BSCONFIG_IPORT}
export POD_ID=${2:-$YP_POD_ID}
#export GEOS=(sas vla man)
export GEOS=(sas vla)
export SHARDS_MAX=65534
export a_geo=$(jq -r ".properties.tags" ./dump.json | tr " " "\n" | grep a_geo | sed -e 's/a_geo_//')
[ "$a_geo" == "msk" ] && export a_geo=$(jq -r ".properties.tags" ./dump.json | tr " " "\n" | grep a_dc | sed -e 's/a_dc_//')
[ -z "$POD_ID" ] && export POD_ID="${a_geo}-ps-cache-global-1"
[ -z "$SERVICE_NAME" ] && export SERVICE_NAME=adele
[ -z "$YP_TOKEN" -a -e "./robot-mailspam-yp/token" ] && export YP_TOKEN=$(cat ./robot-mailspam-yp/token)

export POD_SET_ID=$(yp select-objects --address $a_geo pod --selector '/meta/pod_set_id' --filter "[/meta/id] = \"$POD_ID\"" --config '{token="$YP_TOKEN";}'  | awk '$2 ~ /".*"/ {print $2}' | sed -e 's/"//g')
export POD_SET_ROOT_NAME=$(echo $POD_SET_ID | sed -e "s/$a_geo//;s/^-//g")

for geo in ${GEOS[@]}; do
    export POD_SET_ID="${geo}-${POD_SET_ROOT_NAME}"
    echo "# $geo : $POD_SET_ID"
    echo
    PODS_HOSTS=$(yp select-objects --address $geo pod --selector '/status/dns/persistent_fqdn' --filter "[/meta/pod_set_id] = \"$POD_SET_ID\"" --config '{token="$YP_TOKEN";}' | awk '$2 ~ /".*"/ {print $2}' | sed -e 's/"//g' | sort)
    POD_HOSTS_CNT=$(echo "$PODS_HOSTS" | wc -l)
    i=0
    for pod_host in ${PODS_HOSTS[@]}; do
        START_SHARD=$(( i * SHARDS_MAX / POD_HOSTS_CNT ))
        END_SHARD=$(( (i + 1) * SHARDS_MAX / POD_HOSTS_CNT - 1 ))
        echo "$SERVICE_NAME host:$pod_host,shards:${START_SHARD}-${END_SHARD},search_port_ng:$LJINX_PORT"
        (( i ++ ))
    done
    echo
done
