#!/bin/bash
set -exo pipefail

source config.sh
source recommended_java_args.sh

CORE_DIR="/cores"
export IBM_HEAPDUMP=1
export IBM_HEAP_DUMP=1
export IBM_COREDIR=$CORE_DIR
export IBM_HEAPDUMPDIR=$CORE_DIR
export IBM_JAVACOREDIR=$CORE_DIR
export LANG=en_US.UTF-8
export LD_LIBRARY_PATH=.

source classpath.sh

mkdir -p /dev/shm/gclogs

GC_ARGS="
-XX:ActiveProcessorCount=$CPU_CORES
-XX:+IgnoreUnrecognizedVMOptions
-XX:+HeapDumpOnOutOfMemoryError
-XX:HeapDumpPath=$CORE_DIR
-XcompilationThreads1
-Xmx8G
-Xms256M
-XX:+PrintGC
-XX:+PrintGCDetails
-XX:+UnlockExperimentalVMOptions
-verbose:gc
-XX:+UseShenandoahGC
-XX:ConcGCThreads=2
-XX:ShenandoahGCMode=iu
-XX:-ShenandoahAlwaysClearSoftRefs
-XX:ShenandoahAllocationThreshold=5
-XX:ShenandoahUncommitDelay=100000
-XX:ShenandoahGuaranteedGCInterval=100000
-XX:ShenandoahGarbageThreshold=10
-XX:SoftRefLRUPolicyMSPerMB=1000
-XX:+PrintCodeCache
-XX:ParallelGCThreads=$CPU_CORES
-XX:+UnlockDiagnosticVMOptions
-XX:+PrintGCDateStamps
-XX:+UseGCLogFileRotation -XX:NumberOfGCLogFiles=5 -XX:GCLogFileSize=2M
-Xlog:gc*:/dev/shm/gclogs/gc.log
"

NET_ARGS="-Djava.net.preferIPv4Stack=false -Djava.net.preferIPv6Addresses=true"

exec $BSCONFIG_IDIR/jdk/bin/java \
    $NET_ARGS $GC_ARGS \
    -DPORTO=1 \
    -Djava.library.path=mts_api_proxy \
    -cp $CLASSPATH ru.yandex.mts_api_proxy.MobileIdProxyHttpServer \
    mts_api_proxy.conf
