package ru.yandex.mts_api_proxy;

import java.io.IOException;
import java.util.Timer;

import javax.annotation.Nonnull;

import ru.yandex.collection.Pattern;
import ru.yandex.concurrent.TimerTaskCloser;
import ru.yandex.http.proxy.HttpProxy;
import ru.yandex.http.util.nio.client.AsyncClientRegistrar;
import ru.yandex.mts_api_proxy.config.ImmutableMtsApiProxyConfig;

public class MtsApiProxyHttpServer extends HttpProxy<ImmutableMtsApiProxyConfig> implements AsyncClientRegistrar {
    @Nonnull
    private final MtsTokenRenewalTask mtsTokenRenewalTask;

    public MtsApiProxyHttpServer(final ImmutableMtsApiProxyConfig config) throws IOException {
        super(config);

        final MtsApiClient mtsApiClient = registerClient(
                "MtsApiClient",
                new MtsApiClient(reactor, config.mtsApiConfig()),
                config.mtsApiConfig());
        mtsTokenRenewalTask = new MtsTokenRenewalTask(mtsApiClient, logger().addPrefix("mts-token"));
        closeChain.add(new TimerTaskCloser(mtsTokenRenewalTask));

        register(new Pattern<>("/score", true), new ScoreHandler(mtsApiClient, mtsTokenRenewalTask));
    }

    @Override
    public void start() throws IOException {
        super.start();
        {
            final Timer timer = new Timer("MtsTokenRenewal", true);
            mtsTokenRenewalTask.run();
            timer.schedule(mtsTokenRenewalTask, config.mtsApiConfig().tokenRenewalInterval().toMillis());
        }
    }
}

