package ru.yandex.mts_api_proxy;

import java.util.TimerTask;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;

import javax.annotation.Nonnull;

import ru.yandex.http.util.EmptyFutureCallback;

public class MtsTokenRenewalTask extends TimerTask implements MtsTokenSupplier {
    @Nonnull
    private final MtsApiClient mtsApiClient;
    @Nonnull
    private final AtomicReference<String> token;
    @Nonnull
    private final Logger logger;


    public MtsTokenRenewalTask(
            @Nonnull MtsApiClient mtsApiClient,
            @Nonnull Logger logger) {
        this.mtsApiClient = mtsApiClient;
        this.logger = logger;
        token = new AtomicReference<>();
    }

    @Override
    public String token() {
        return token.get();
    }

    private String requestToken()
            throws ExecutionException, InterruptedException {
        return mtsApiClient.token(EmptyFutureCallback.instance()).get();
    }

    @Override
    public void run() {
        try {
            final String newToken = requestToken();
            if (newToken != null) {
                token.lazySet(newToken);
            }
        } catch (Throwable t) {
            logger.log(Level.WARNING, "MTS token renewal failed", t);
        }
    }
}

