package ru.yandex.mts_api_proxy;

import javax.annotation.Nonnull;

import org.apache.http.HttpStatus;
import org.apache.http.entity.ContentType;
import org.apache.http.nio.entity.NStringEntity;

import ru.yandex.http.proxy.AbstractProxySessionCallback;
import ru.yandex.http.proxy.ProxyRequestHandler;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;

class ScoreHandler implements ProxyRequestHandler {
    @Nonnull
    private final MtsApiClient mtsApiClient;
    @Nonnull
    private final MtsTokenSupplier mtsTokenSupplier;

    public ScoreHandler(@Nonnull MtsApiClient mtsApiClient, @Nonnull MtsTokenSupplier mtsTokenSupplier) {
        this.mtsApiClient = mtsApiClient;
        this.mtsTokenSupplier = mtsTokenSupplier;
    }

    @Override
    public void handle(ProxySession session) throws BadRequestException {
        final MtsApiClient client = mtsApiClient.adjust(session.context());

        final long msisdn = session.params().getLong("msisdn");

        client.score(msisdn, mtsTokenSupplier.token(), new AbstractProxySessionCallback<>(session) {
            @Override
            public void completed(Double token) {
                session.response(
                        HttpStatus.SC_OK,
                        new NStringEntity(
                                token.toString(),
                                ContentType.TEXT_PLAIN.withCharset(session.acceptedCharset())));
            }
        });
    }
}
