package ru.yandex.mts_api_proxy.config;

import javax.annotation.Nonnull;

import ru.yandex.client.tvm2.Tvm2ClientConfigBuilder;
import ru.yandex.http.config.HttpHostConfig;
import ru.yandex.http.util.server.AbstractHttpProxyConfigBuilder;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public abstract class AbstractMtsApiProxyConfigBuilder
        <T extends AbstractMtsApiProxyConfigBuilder<T>>
        extends AbstractHttpProxyConfigBuilder<T>
        implements MtsApiProxyConfig {
    @Nonnull
    private Tvm2ClientConfigBuilder tvm2ClientConfig;
    @Nonnull
    private MtsApiClientConfigBuilder mtsApiConfig;

    protected AbstractMtsApiProxyConfigBuilder(final MtsApiProxyConfig config) {
        super(config);
        tvm2ClientConfig = new Tvm2ClientConfigBuilder(config.tvm2ClientConfig());
        mtsApiConfig = new MtsApiClientConfigBuilder(config.mtsApiConfig());
    }

    protected AbstractMtsApiProxyConfigBuilder(
            final IniConfig config,
            final MtsApiProxyConfig defaults)
            throws ConfigException {
        super(config, defaults);
        tvm2ClientConfig = new Tvm2ClientConfigBuilder(
                config.section("tvm2"),
                defaults.tvm2ClientConfig());

        mtsApiConfig = new MtsApiClientConfigBuilder(
                config.section("mts-api"),
                defaults.mtsApiConfig());
    }

    @Nonnull
    @Override
    public Tvm2ClientConfigBuilder tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    public T tvm2ClientConfig(Tvm2ClientConfigBuilder tvm2ClientConfig) {
        this.tvm2ClientConfig = tvm2ClientConfig;
        return self();
    }

    @Nonnull
    @Override
    public MtsApiClientConfigBuilder mtsApiConfig() {
        return mtsApiConfig;
    }

    public T gozoraConfig(HttpHostConfig gozoraConfig) {
        this.mtsApiConfig = new MtsApiClientConfigBuilder(mtsApiConfig);
        return self();
    }
}

