package ru.yandex.mts_api_proxy.config;

import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Base64;

import javax.annotation.Nonnull;

import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.message.BasicHeader;

import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMtsApiClientConfig
        extends ImmutableHttpHostConfig
        implements MtsApiClientConfig {
    @Nonnull
    private final String consumerKey;
    @Nonnull
    private final String consumerSecret;
    @Nonnull
    private final String clientId;
    @Nonnull
    private final Header basicAuthorizationHeader;
    @Nonnull
    private final Header destinationTokenUrlHeader;
    @Nonnull
    private final Header destinationScoreUrlHeader;
    @Nonnull
    private final Header clientIdHeader;
    @Nonnull
    private final HttpHost mtsApiHost;
    @Nonnull
    private final Duration tokenRenewalInterval;

    public ImmutableMtsApiClientConfig(MtsApiClientConfig config) throws ConfigException {
        super(config);

        this.consumerKey = config.consumerKey();
        this.consumerSecret = config.consumerSecret();
        this.clientId = config.clientId();
        this.mtsApiHost = config.mtsApiHost();
        this.tokenRenewalInterval = config.tokenRenewalInterval();

        basicAuthorizationHeader = new BasicHeader(
                "Authorization",
                "Basic " + new String(
                        Base64.getUrlEncoder().encode(
                                (consumerKey + ':' + consumerSecret).getBytes(Charset.defaultCharset())
                        ), Charset.defaultCharset()));

        destinationTokenUrlHeader = new BasicHeader(
                "x-ya-dest-url",
                mtsApiHost + "/token");

        destinationScoreUrlHeader = new BasicHeader(
                "x-ya-dest-url",
                mtsApiHost + "/bnkscor/1.1.0/score");

        clientIdHeader = new BasicHeader(
                "x-ya-client-id",
                clientId);
    }

    @Override
    @Nonnull
    public String consumerKey() {
        return consumerKey;
    }

    @Override
    @Nonnull
    public String consumerSecret() {
        return consumerSecret;
    }

    @Nonnull
    public Header basicAuthorizationHeader() {
        return basicAuthorizationHeader;
    }

    @Nonnull
    public Header destinationTokenUrlHeader() {
        return destinationTokenUrlHeader;
    }

    @Nonnull
    public Header destinationScoreUrlHeader() {
        return destinationScoreUrlHeader;
    }

    @Override
    @Nonnull
    public String clientId() {
        return clientId;
    }

    @Override
    @Nonnull
    public HttpHost mtsApiHost() {
        return mtsApiHost;
    }

    @Nonnull
    public Header clientIdHeader() {
        return clientIdHeader;
    }

    @Override
    @Nonnull
    public Duration tokenRenewalInterval() {
        return tokenRenewalInterval;
    }
}

