package ru.yandex.mts_api_proxy.config;

import javax.annotation.Nonnull;

import ru.yandex.client.tvm2.ImmutableTvm2ClientConfig;
import ru.yandex.http.util.server.ImmutableHttpProxyConfig;
import ru.yandex.parser.config.ConfigException;

public class ImmutableMtsApiProxyConfig
        extends ImmutableHttpProxyConfig
        implements MtsApiProxyConfig {
    @Nonnull
    private final ImmutableTvm2ClientConfig tvm2ClientConfig;
    @Nonnull
    private final ImmutableMtsApiClientConfig mtsApiConfig;

    public ImmutableMtsApiProxyConfig(final MtsApiProxyConfig config)
            throws ConfigException {
        super(config);
        tvm2ClientConfig = new ImmutableTvm2ClientConfig(config.tvm2ClientConfig());
        mtsApiConfig = new ImmutableMtsApiClientConfig(config.mtsApiConfig());
    }

    @Nonnull
    @Override
    public ImmutableTvm2ClientConfig tvm2ClientConfig() {
        return tvm2ClientConfig;
    }

    @Nonnull
    @Override
    public ImmutableMtsApiClientConfig mtsApiConfig() {
        return mtsApiConfig;
    }
}

