package ru.yandex.mts_api_proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class MtsApiClientConfigBuilder
        extends AbstractMtsApiClientConfigBuilder<MtsApiClientConfigBuilder> {
    public MtsApiClientConfigBuilder() {
        super(MtsApiClientConfigDefaults.INSTANCE);
    }

    public MtsApiClientConfigBuilder(final MtsApiClientConfig config) {
        super(config);
    }

    public MtsApiClientConfigBuilder(final IniConfig config)
            throws ConfigException {
        super(config, MtsApiClientConfigDefaults.INSTANCE);
    }

    public MtsApiClientConfigBuilder(
            final IniConfig config,
            final MtsApiClientConfig defaults)
            throws ConfigException {
        super(config, defaults);
    }

    @Override
    public MtsApiClientConfigBuilder self() {
        return this;
    }

    public ImmutableMtsApiClientConfig build() throws ConfigException {
        return new ImmutableMtsApiClientConfig(this);
    }
}

