package ru.yandex.mts_api_proxy.config;

import java.time.Duration;

import javax.annotation.Nonnull;

import org.apache.http.HttpHost;

import ru.yandex.http.config.HttpHostConfigDefaults;

public class MtsApiClientConfigDefaults
        extends HttpHostConfigDefaults
        implements MtsApiClientConfig {

    public static final MtsApiClientConfigDefaults INSTANCE =
            new MtsApiClientConfigDefaults();

    protected MtsApiClientConfigDefaults() {
    }

    @Override
    @Nonnull
    public String consumerKey() {
        throw new RuntimeException("default consumer key is not available");
    }

    @Override
    @Nonnull
    public String consumerSecret() {
        throw new RuntimeException("default consumer secret is not available");
    }

    @Override
    @Nonnull
    public String clientId() {
        throw new RuntimeException("default client id is not available");
    }

    @Override
    @Nonnull
    public HttpHost mtsApiHost() {
        throw new RuntimeException("default mts api host is not available");
    }

    @Override
    @Nonnull
    public Duration tokenRenewalInterval() {
        return Duration.ofSeconds(60);
    }
}

