package ru.yandex.mts_api_proxy.config;

import ru.yandex.parser.config.ConfigException;
import ru.yandex.parser.config.IniConfig;

public final class MtsApiProxyConfigBuilder
        extends AbstractMtsApiProxyConfigBuilder<MtsApiProxyConfigBuilder> {
    public MtsApiProxyConfigBuilder() {
        super(MtsApiProxyConfigDefaults.INSTANCE);
    }

    public MtsApiProxyConfigBuilder(final MtsApiProxyConfig config) {
        super(config);
    }

    public MtsApiProxyConfigBuilder(final IniConfig config)
            throws ConfigException {
        super(config, MtsApiProxyConfigDefaults.INSTANCE);
    }

    public MtsApiProxyConfigBuilder(
            final IniConfig config,
            final MtsApiProxyConfig defaults)
            throws ConfigException {
        super(config, defaults);
    }

    @Override
    public MtsApiProxyConfigBuilder self() {
        return this;
    }

    public ImmutableMtsApiProxyConfig build() throws ConfigException {
        return new ImmutableMtsApiProxyConfig(this);
    }
}

