package ru.yandex.mail.so.sarlacc;

import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpStatus;
import org.apache.http.nio.protocol.HttpAsyncExchange;
import org.apache.http.nio.protocol.HttpAsyncRequestHandler;
import org.apache.http.protocol.HttpContext;

import ru.yandex.http.proxy.BasicProxySession;
import ru.yandex.http.proxy.ProxySession;
import ru.yandex.http.util.BadRequestException;
import ru.yandex.http.util.ServerException;
import ru.yandex.http.util.YandexHttpStatus;
import ru.yandex.http.util.nio.AsyncStringConsumer;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.mail.so.sarlacc.config.ImmutableShinglerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.stater.RequestInfo;
import ru.yandex.stater.RequestsStater;
import ru.yandex.util.timesource.TimeSource;

public abstract class AbstractShinglerHandler extends RequestsStater implements HttpAsyncRequestHandler<String>
{
    protected final Sarlacc sarlacc;
    protected final ImmutableShinglerConfig config;

    public enum RequestType {
        GET("get"),
        PUT("put");

        private final String requestType;

        RequestType(final String requestType) {
            this.requestType = requestType;
        }

        @Override
        public String toString() {
            return requestType;
        }
    }

    private final RequestType requestType;

    protected AbstractShinglerHandler(
        final ImmutableShinglerConfig config,
        final Sarlacc sarlacc,
        final RequestType requestType)
        throws ConfigException
    {
        super(config);
        this.config = config;
        this.sarlacc = sarlacc;
        this.requestType = requestType;
    }

    public ImmutableShinglerConfig config() {
        return config;
    }

    public void stat(final int status, final long startTime) {
        accept(new RequestInfo(TimeSource.INSTANCE.currentTimeMillis(), status, startTime, startTime, 0L, 0L));
    }

    @Override
    public AsyncStringConsumer processRequest(final HttpRequest request, final HttpContext context)
        throws BadRequestException
    {
        if (RequestHandlerMapper.POST.equals(request.getRequestLine().getMethod())
                && !(request instanceof HttpEntityEnclosingRequest))
        {
            throw new BadRequestException("Payload expected");
        }
        return new AsyncStringConsumer();
    }

    public abstract void searchData(final ProxySession session, final long startTime);

    public abstract void saveData(final ProxySession session, final long startTime);

    @Override
    @SuppressWarnings("FutureReturnValueIgnored")
    public void handle(final String payload, final HttpAsyncExchange exchange, final HttpContext context)
        throws HttpException
    {
        long startTime = TimeSource.INSTANCE.currentTimeMillis();
        ProxySession session = new BasicProxySession(sarlacc, exchange, context);
        String method = exchange.getRequest().getRequestLine().getMethod();
        String uri = exchange.getRequest().getRequestLine().getUri();
        session.logger().info("AbstractLogRecordsHandler: type=" + config.type() + ", method=" + method
            + ", path=" + session.uri().rawPath() + ", query=" + session.uri().rawQuery());
        if (RequestHandlerMapper.GET.equals(method)) {
            session.logger().info("Search query=" + uri);
            if (this.requestType == RequestType.GET) {
                searchData(session, startTime);
            } else if (this.requestType == RequestType.PUT) {
                saveData(session, startTime);
            } else {
                stat(YandexHttpStatus.SC_NOT_ACCEPTABLE, startTime);
                throw new ServerException(HttpStatus.SC_NOT_ACCEPTABLE, "Unacceptable request");
            }
            stat(YandexHttpStatus.SC_OK, startTime);
            session.logger().info("AbstractShinglerHandler.handle GET: finished");
        } else if (RequestHandlerMapper.POST.equals(method)) {
            if (this.requestType == RequestType.PUT) {
                saveData(session, startTime);
            } else {
                stat(YandexHttpStatus.SC_NOT_ACCEPTABLE, startTime);
                throw new ServerException(HttpStatus.SC_NOT_ACCEPTABLE, "Unacceptable request");
            }
            stat(YandexHttpStatus.SC_OK, startTime);
            session.logger().info("AbstractShinglerHandler.handle POST: finished");
        } else {
            stat(YandexHttpStatus.SC_METHOD_NOT_ALLOWED, startTime);
            throw new ServerException(HttpStatus.SC_METHOD_NOT_ALLOWED, "Method Not Allowed");
        }
    }
}
