package ru.yandex.mail.so.sarlacc;

import org.apache.http.HttpStatus;

import ru.yandex.http.proxy.ProxySession;
import ru.yandex.mail.so.sarlacc.config.ImmutableShinglerConfig;
import ru.yandex.parser.config.ConfigException;

public class MassShinglerHandler extends AbstractShinglerHandler {
    enum Route {
        IN,
        OUT;
    }

    private final Route route;

    public MassShinglerHandler(
        final ImmutableShinglerConfig config,
        final Sarlacc sarlacc,
        final RequestType requestType,
        final Route route)
        throws ConfigException
    {
        super(config, sarlacc, requestType);
        this.route = route;
    }

    public Route route() {
        return route;
    }

    @Override
    public void searchData(final ProxySession session, final long startTime) {
        session.response(HttpStatus.SC_OK);
    }

    @Override
    public void saveData(final ProxySession session, final long startTime) {
        session.response(HttpStatus.SC_OK);
    }
}
