package ru.yandex.mail.so.sarlacc;

import java.io.IOException;

import ru.yandex.collection.Pattern;
import ru.yandex.function.GenericBiConsumer;
import ru.yandex.http.config.ImmutableHttpHostConfig;
import ru.yandex.http.util.nio.client.AsyncClient;
import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.http.util.request.RequestInfo;
import ru.yandex.http.util.request.RequestPatternParser;
import ru.yandex.mail.so.sarlacc.config.ImmutableSarlaccConfig;
import ru.yandex.mail.so.sarlacc.config.ImmutableShinglerConfig;
import ru.yandex.parser.config.ConfigException;
import ru.yandex.search.proxy.universal.UniversalSearchProxy;

public class Sarlacc extends UniversalSearchProxy<ImmutableSarlaccConfig>
{
    private final AsyncClient producerAsyncClient;

    public Sarlacc(final ImmutableSarlaccConfig config) throws ConfigException, IOException
    {
        super(config);
        config.shinglersConfig().shinglers().traverse(new ShinglerVisitor());
        ImmutableHttpHostConfig producerAsyncClientConfig = config.producerAsyncClientConfig();
        if (producerAsyncClientConfig == null) {
            producerAsyncClient = null;
        } else {
            producerAsyncClient = client("AsyncProducer", producerAsyncClientConfig);
        }
    }

    @SuppressWarnings("unused")
    public AsyncClient producerAsyncClient() {
        return producerAsyncClient;
    }

    @Override
    public void start() throws IOException {
        super.start();
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    private class ShinglerVisitor
        implements GenericBiConsumer<Pattern<RequestInfo>, ImmutableShinglerConfig, ConfigException>
    {
        @Override
        public void accept(final Pattern<RequestInfo> pattern, final ImmutableShinglerConfig config)
            throws ConfigException
        {
            if (config.type() == null) {
                return;
            }
            String path = pattern.toString();
            if (!path.endsWith("/")) {
                path += '/';
            }
            registerHandler(
                config.type(),
                config.type().createGetHandler(config, Sarlacc.this, AbstractShinglerHandler.RequestType.GET),
                pattern,
                path + AbstractShinglerHandler.RequestType.GET,
                RequestHandlerMapper.GET);
            registerHandler(
                config.type(),
                config.type().createPutHandler(config, Sarlacc.this, AbstractShinglerHandler.RequestType.PUT),
                pattern,
                path + AbstractShinglerHandler.RequestType.PUT,
                config.type().httpPutMethod());
        }

        private void registerHandler(
            final ShinglerType shinglerType,
            final AbstractShinglerHandler handler,
            final Pattern<RequestInfo> pattern,
            final String path,
            final String httpMethod)
            throws ConfigException
        {
            if (handler != null) {
                register(pattern, handler);
                if (shinglerType != ShinglerType.NULL) {
                    registerStater(handler);
                    logger().info("Registering of shingler <" + shinglerType + ">: " + path);
                    register(RequestPatternParser.INSTANCE.apply(path), handler, httpMethod);
                }
            }
        }
    }
}
