package ru.yandex.mail.so.sarlacc;

import java.util.HashMap;
import java.util.Map;

public enum ShingleCounter {
    HAM(1, "ham"),
    SPAM(2, "spam"),
    MALIC(3, "malic"),
    PERS_HAM(4, "pers_ham"),
    PERS_SPAM(5, "pers_spam");

    private static final Map<Integer, ShingleCounter> ids;
    private final String name;
    private final int id;

    static {
        ids = new HashMap<>();
        for (ShingleCounter counter : values()) {
            ids.put(counter.id(), counter);
        }
    }

    ShingleCounter(final int id, final String name) {
        this.id = id;
        this.name = name;
    }

    public int id() {
        return id;
    }

    @Override
    public String toString() {
        return name;
    }

    public static ShingleCounter fromId(final int id) {
        return ids.get(id);
    }
}
