package ru.yandex.mail.so.sarlacc;

import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;

import ru.yandex.client.so.shingler.ShingleType;

public class ShingleStats {
    private static final Pattern RE_DELIM = Pattern.compile("-\\|_");

    @SuppressWarnings("unused")
    private final String hashValue;
    @SuppressWarnings("unused")
    private final ShingleType type;
    private final Map<ShingleCounter, Long> counters;

    @SuppressWarnings("unused")
    public ShingleStats(final String hashValue, final ShingleType shingleType) {
        this.hashValue = hashValue;
        type = shingleType;
        counters = new HashMap<>();
        for (ShingleCounter counter : ShingleCounter.values()) {
            counters.put(counter, 0L);
        }
    }

    @SuppressWarnings("unused")
    public ShingleStats(final String hashStats) {
        counters = new HashMap<>();
        String[] parts = hashStats.split("=");
        String[] subParts0 = RE_DELIM.split(parts[0]);
        String[] subParts1;
        ShingleCounter counter;
        hashValue = subParts0[0];
        type = ShingleType.fromId(Integer.parseInt(subParts0[1]));
        if (parts.length > 1 && parts[1].length() > 0) {
            subParts1 = RE_DELIM.split(parts[1]);
            counter = ShingleCounter.fromId(Integer.parseInt(subParts1[1]));
            counters.put(counter, Long.parseUnsignedLong(subParts1[0]));
        }
    }
}
