package ru.yandex.mail.so.sarlacc;

import ru.yandex.http.util.request.RequestHandlerMapper;
import ru.yandex.mail.so.sarlacc.config.ImmutableShinglerConfig;
import ru.yandex.parser.config.ConfigException;

public enum ShinglerType {
    NULL {
        @Override
        public AbstractShinglerHandler createGetHandler(
            final ImmutableShinglerConfig config,
            final Sarlacc sarlacc,
            final AbstractShinglerHandler.RequestType requestType)
            throws ConfigException
        {
            return new NullShinglerHandler(config, sarlacc, requestType);
        }

        @Override
        public AbstractShinglerHandler createPutHandler(
            final ImmutableShinglerConfig config,
            final Sarlacc sarlacc,
            final AbstractShinglerHandler.RequestType requestType)
            throws ConfigException
        {
            return new NullShinglerHandler(config, sarlacc, requestType);
        }

        @Override
        public String httpPutMethod() {
            return RequestHandlerMapper.GET;
        }
    },
    MASS_IN {
        @Override
        public AbstractShinglerHandler createGetHandler(
            final ImmutableShinglerConfig config,
            final Sarlacc sarlacc,
            final AbstractShinglerHandler.RequestType requestType)
            throws ConfigException
        {
            return new MassShinglerHandler(config, sarlacc, requestType, MassShinglerHandler.Route.IN);
        }

        @Override
        public AbstractShinglerHandler createPutHandler(
            final ImmutableShinglerConfig config,
            final Sarlacc sarlacc,
            final AbstractShinglerHandler.RequestType requestType)
            throws ConfigException
        {
            return null;
        }

        @Override
        public String httpPutMethod() {
            return RequestHandlerMapper.GET;
        }
    },
    MASS_OUT {
        @Override
        public AbstractShinglerHandler createGetHandler(
            final ImmutableShinglerConfig config,
            final Sarlacc sarlacc,
            final AbstractShinglerHandler.RequestType requestType)
            throws ConfigException
        {
            return new MassShinglerHandler(config, sarlacc, requestType, MassShinglerHandler.Route.OUT);
        }

        @Override
        public AbstractShinglerHandler createPutHandler(
            final ImmutableShinglerConfig config,
            final Sarlacc sarlacc,
            final AbstractShinglerHandler.RequestType requestType)
            throws ConfigException
        {
            return null;
        }

        @Override
        public String httpPutMethod() {
            return RequestHandlerMapper.GET;
        }
    };

    public abstract AbstractShinglerHandler createGetHandler(
        final ImmutableShinglerConfig config,
        final Sarlacc sarlacc,
        final AbstractShinglerHandler.RequestType requestType)
        throws ConfigException;

    public abstract AbstractShinglerHandler createPutHandler(
        final ImmutableShinglerConfig config,
        final Sarlacc sarlacc,
        final AbstractShinglerHandler.RequestType requestType)
        throws ConfigException;

    public abstract String httpPutMethod();
}
