package ru.yandex.mail.so.sarlacc;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

import ru.yandex.function.GenericFunction;
import ru.yandex.parser.string.DurationParser;

public enum ShinglesPeriod {
    TEN_MINUTES("10m", "1d"),
    DAY("1d", "2w"),
    TWO_WEEKS("2w", "4w");

    private final long period;
    private final long ttl;

    private static final Map<Long, ShinglesPeriod> shinglesPeriods;

    static {
        shinglesPeriods = new HashMap<>();
        for (ShinglesPeriod value : values()) {
            shinglesPeriods.put(value.ttl, value);
        }
    }

    @SuppressWarnings("unused")
    ShinglesPeriod(final long period, final long ttl) {
        this.period = period;
        this.ttl = ttl;
    }

    ShinglesPeriod(final String period, final String ttl) {
        this.period = parseLongSafe(period);
        this.ttl = parseLongSafe(ttl);
    }

    public long period() {
        return period;
    }

    public long ttl() {
        return ttl;
    }

    public static ShinglesPeriod get(final long period) {
        return shinglesPeriods.get(period);
    }

    static long parseLongSafe(final String s) {
        try {
            return DurationParser.POSITIVE_LONG.apply(s);
        } catch (Exception e) {
            return 0;
        }
    }

    public static class Parser implements GenericFunction<String, ShinglesPeriod, RuntimeException> {
        @Override
        public ShinglesPeriod apply(final String value) {
            try {
                return ShinglesPeriod.valueOf(value.trim().toUpperCase(Locale.ROOT).replace('-', '_'));
            } catch (Exception unused) {
                return ShinglesPeriod.get(parseLongSafe(value));
            }
        }
    }
}
